#include <stdio.h>
#include <string.h>
#include "BufferedFile.h"

int main()
{
	BufferedFile TestFile("Test file", B_READ_ONLY, 10);
	if(TestFile.InitCheck() == B_NO_ERROR)
	{
		bool ReadCorrectly = true;
		uint32 Buffer32[45];
		if(TestFile.ReadNumber(Buffer32,sizeof(*Buffer32),45) != 45)
			ReadCorrectly = false;
		uint16 Buffer16[20];
		uint32 Counter;
		for(Counter = 0; Counter < 20; Counter++)
			if(TestFile.ReadNumber(&Buffer16[Counter],sizeof(*Buffer16),1) != 1)
				ReadCorrectly = false;
		char HelloBuffer[6];
		if(TestFile.ReadString(HelloBuffer,6) != B_NO_ERROR)
			ReadCorrectly = false;
		char RawBuffer[11];
		if(TestFile.ReadRaw(RawBuffer,11) != 11)
			ReadCorrectly = false;		
		char Dummy;
		if(TestFile.ReadNumber(&Dummy,sizeof(Dummy),1))
			ReadCorrectly = false;
		printf("File %s read successfully\n",ReadCorrectly?"was":"was not");
		if(ReadCorrectly)
		{
			for(Counter = 0; Counter < 45; Counter++)
				if(Buffer32[Counter] != Counter)
					ReadCorrectly = false;
			for(Counter = 0; Counter < 20; Counter++)
				if(Buffer16[Counter] != Counter)
					ReadCorrectly = false;
			if(strcmp(HelloBuffer,"Hello") != 0)
				ReadCorrectly = false;
			if(strcmp(RawBuffer,"*Raw data*") != 0)
				ReadCorrectly = false;
			printf("Numbers, string, and raw data %s those which should have been written\n",
				ReadCorrectly?"matched":"did not match");
		}
	}
	else
		printf("\"Test file\" could not be opened for read! Error = %08X\n"
			"Did you run DemoWrite first?\n",(int)TestFile.InitCheck());
}
